/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.math;

import icyllis.modernui.math.MathUtil;
import icyllis.modernui.math.Matrix3;
import icyllis.modernui.math.Matrix4;
import icyllis.modernui.math.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Quaternion {
    protected float x;
    protected float y;
    protected float z;
    protected float w;

    public Quaternion() {
    }

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Nonnull
    public static Quaternion copy(@Nullable Quaternion q) {
        return q == null ? Quaternion.identity() : q.copy();
    }

    @Nonnull
    public static Quaternion identity() {
        Quaternion q = new Quaternion();
        q.w = 1.0f;
        return q;
    }

    @Nonnull
    public static Quaternion makeEulerAngles(float rotationX, float rotationY, float rotationZ) {
        Quaternion q = new Quaternion();
        q.setFromEulerAngles(rotationX, rotationY, rotationZ);
        return q;
    }

    @Nonnull
    public static Quaternion makeAxisAngle(@Nonnull Vector3 axis, float angle) {
        Quaternion q = new Quaternion();
        q.setFromAxisAngle(axis, angle);
        return q;
    }

    @Nonnull
    public static Quaternion makeAxisAngle(float axisX, float axisY, float axisZ, float angle) {
        Quaternion q = new Quaternion();
        q.setFromAxisAngle(axisX, axisY, axisZ, angle);
        return q;
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void set(@Nonnull Quaternion q) {
        this.x = q.x;
        this.y = q.y;
        this.z = q.z;
        this.w = q.w;
    }

    public void add(@Nonnull Quaternion q) {
        this.w += q.w;
        this.x += q.x;
        this.y += q.y;
        this.z += q.z;
    }

    public void subtract(@Nonnull Quaternion q) {
        this.w -= q.w;
        this.x -= q.x;
        this.y -= q.y;
        this.z -= q.z;
    }

    public void multiply(float s2) {
        this.x *= s2;
        this.y *= s2;
        this.z *= s2;
        this.w *= s2;
    }

    public void multiply(@Nonnull Quaternion q) {
        this.set(this.w * q.x + this.x * q.w + this.y * q.z - this.z * q.y, this.w * q.y - this.x * q.z + this.y * q.w + this.z * q.x, this.w * q.z + this.x * q.y - this.y * q.x + this.z * q.w, this.w * q.w - this.x * q.x - this.y * q.y - this.z * q.z);
    }

    public float length() {
        return MathUtil.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthSquared() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float dot(float x, float y, float z, float w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    public float dot(@Nonnull Quaternion q) {
        return this.x * q.x + this.y * q.y + this.z * q.z + this.w * q.w;
    }

    public void inverse() {
        float sq = this.lengthSquared();
        if (MathUtil.approxEqual(sq, 1.0f)) {
            this.conjugate();
        } else {
            float invSq = 1.0f / sq;
            this.w *= invSq;
            this.x = -this.x * invSq;
            this.y = -this.y * invSq;
            this.z = -this.z * invSq;
        }
    }

    public boolean isNormalized() {
        return MathUtil.approxEqual(this.lengthSquared(), 1.0f);
    }

    public void normalize() {
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            this.setIdentity();
        } else {
            float invNorm = 1.0f / MathUtil.sqrt(sq);
            this.x *= invNorm;
            this.y *= invNorm;
            this.z *= invNorm;
            this.w *= invNorm;
        }
    }

    public void normalizeFast() {
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            this.setIdentity();
        } else {
            float invNorm = MathUtil.fastInvSqrt(sq);
            this.x *= invNorm;
            this.y *= invNorm;
            this.z *= invNorm;
            this.w *= invNorm;
        }
    }

    public void setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
    }

    public boolean isIdentity() {
        return MathUtil.approxZero(this.x, this.y, this.z) && MathUtil.approxEqual(this.w, 1.0f);
    }

    public void setIdentity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public void conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
    }

    public void slerp(@Nonnull Quaternion a, float t) {
        this.slerp(this, a, t);
    }

    public void slerp(@Nonnull Quaternion a, @Nonnull Quaternion b, float t) {
        if (t <= 0.0f) {
            this.set(a);
        } else if (t >= 1.0f) {
            this.set(b);
        } else if (MathUtil.approxZero(a.lengthSquared())) {
            if (MathUtil.approxZero(b.lengthSquared())) {
                this.setIdentity();
            } else {
                this.set(b);
            }
        } else if (MathUtil.approxZero(b.lengthSquared())) {
            this.set(a);
        } else {
            float s2;
            float cosHalfAngle = a.dot(b);
            if (cosHalfAngle >= 0.95f) {
                s2 = 1.0f - t;
            } else if (cosHalfAngle <= -0.99f) {
                t = 0.5f;
                s2 = 0.5f;
            } else {
                float halfAngle;
                float sinHalfAngle;
                boolean negative = false;
                if (cosHalfAngle <= -1.0E-6f) {
                    cosHalfAngle = -cosHalfAngle;
                    negative = true;
                }
                if (Math.abs(sinHalfAngle = MathUtil.sin(halfAngle = MathUtil.acos(cosHalfAngle))) < 0.001f) {
                    t = 0.5f;
                    s2 = 0.5f;
                } else {
                    sinHalfAngle = 1.0f / sinHalfAngle;
                    s2 = MathUtil.sin((1.0f - t) * halfAngle) * sinHalfAngle;
                    t = MathUtil.sin(t * halfAngle) * sinHalfAngle;
                    if (negative) {
                        t = -t;
                    }
                }
            }
            this.x = a.x * s2 + b.x * t;
            this.y = a.y * s2 + b.y * t;
            this.z = a.z * s2 + b.z * t;
            this.w = a.w * s2 + b.w * t;
        }
    }

    public void rotateByAxis(@Nonnull Vector3 axis, float angle) {
        this.rotateByAxis(axis.x, axis.y, axis.z, angle);
    }

    public void rotateByAxis(float axisX, float axisY, float axisZ, float angle) {
        if (angle == 0.0f) {
            return;
        }
        float sin = MathUtil.sin(angle *= 0.5f);
        float qx = axisX * sin;
        float qy = axisY * sin;
        float qz = axisZ * sin;
        float qw = MathUtil.cos(angle);
        this.set(this.x * qw + this.y * qz - this.z * qy + this.w * qx, -this.x * qz + this.y * qw + this.z * qx + this.w * qy, this.x * qy - this.y * qx + this.z * qw + this.w * qz, -this.x * qx - this.y * qy - this.z * qz + this.w * qw);
    }

    public void rotateX(float angle) {
        if (angle == 0.0f) {
            return;
        }
        float sin = MathUtil.sin(angle *= 0.5f);
        float cos = MathUtil.cos(angle);
        this.set(this.x * cos + this.w * sin, this.y * cos + this.z * sin, -this.y * sin + this.z * cos, -this.x * sin + this.w * cos);
    }

    public void rotateY(float angle) {
        if (angle == 0.0f) {
            return;
        }
        float sin = MathUtil.sin(angle *= 0.5f);
        float cos = MathUtil.cos(angle);
        this.set(this.x * cos - this.z * sin, this.y * cos + this.w * sin, this.x * sin + this.z * cos, -this.y * sin + this.w * cos);
    }

    public void rotateZ(float angle) {
        if (angle == 0.0f) {
            return;
        }
        float sin = MathUtil.sin(angle *= 0.5f);
        float cos = MathUtil.cos(angle);
        this.set(this.x * cos + this.y * sin, -this.x * sin + this.y * cos, this.z * cos + this.w * sin, -this.z * sin + this.w * cos);
    }

    public void rotateByEuler(float rotationX, float rotationY, float rotationZ) {
        this.rotateX(rotationX);
        this.rotateY(rotationY);
        this.rotateZ(rotationZ);
    }

    public void setFromAxisAngle(@Nonnull Vector3 axis, float angle) {
        this.setFromAxisAngle(axis.x, axis.y, axis.z, angle);
    }

    public void setFromAxisAngle(float axisX, float axisY, float axisZ, float angle) {
        if (MathUtil.approxZero(axisX, axisY, axisZ)) {
            this.setIdentity();
        } else {
            float sin = MathUtil.sin(angle *= 0.5f);
            this.x = axisX * sin;
            this.y = axisY * sin;
            this.z = axisZ * sin;
            this.w = MathUtil.cos(angle);
        }
    }

    public void setFromEulerAngles(float rotationX, float rotationY, float rotationZ) {
        if (MathUtil.approxZero(rotationX, rotationY, rotationZ)) {
            this.setIdentity();
        } else {
            float sx = MathUtil.sin(rotationX *= 0.5f);
            float cx = MathUtil.cos(rotationX);
            float sy = MathUtil.sin(rotationY *= 0.5f);
            float cy = MathUtil.cos(rotationY);
            float sz = MathUtil.sin(rotationZ *= 0.5f);
            float cz = MathUtil.cos(rotationZ);
            float cc = cy * cz;
            float ss = sy * sz;
            float cs = cy * sz;
            float sc = sy * cz;
            this.w = cc * cx - ss * sx;
            this.x = cc * sx + ss * cx;
            this.y = sc * cx + cs * sx;
            this.z = cs * cx - sc * sx;
        }
    }

    public float toAxisAngle(@Nonnull Vector3 axis) {
        float l = this.x * this.x + this.y * this.y + this.z * this.z;
        if (MathUtil.approxZero(l)) {
            axis.x = 1.0f;
            axis.y = 0.0f;
            axis.z = 0.0f;
            return 0.0f;
        }
        l = 1.0f / MathUtil.sqrt(l);
        axis.x = this.x * l;
        axis.y = this.y * l;
        axis.z = this.z * l;
        return MathUtil.acos(this.w) * 2.0f;
    }

    public float toAxisAngle(@Nonnull float[] axis) {
        if (axis.length < 3) {
            throw new IllegalArgumentException("The array length must be at least 3");
        }
        float l = this.x * this.x + this.y * this.y + this.z * this.z;
        if (MathUtil.approxZero(l)) {
            axis[0] = 1.0f;
            axis[1] = 0.0f;
            axis[2] = 0.0f;
            return 0.0f;
        }
        l = 1.0f / MathUtil.sqrt(l);
        axis[0] = this.x * l;
        axis[1] = this.y * l;
        axis[2] = this.z * l;
        return MathUtil.acos(this.w) * 2.0f;
    }

    public void toEulerAngles(@Nonnull Vector3 result) {
        float f = this.x * this.y + this.z * this.w;
        float sqx = this.x * this.x;
        float sqy = this.y * this.y;
        float sqz = this.z * this.z;
        float sqw = this.w * this.w;
        float sq = sqx + sqy + sqz + sqw;
        if (f > 0.499f * sq) {
            result.x = 0.0f;
            result.y = 2.0f * MathUtil.atan2(this.x, this.w);
            result.z = 1.5707964f;
        } else if (f < -0.499f * sq) {
            result.x = 0.0f;
            result.y = -2.0f * MathUtil.atan2(this.x, this.w);
            result.z = -1.5707964f;
        } else {
            result.x = MathUtil.atan2(2.0f * (this.x * this.w - this.y * this.z), -sqx + sqy - sqz + sqw);
            result.y = MathUtil.atan2(2.0f * (this.y * this.w - this.x * this.z), sqx - sqy - sqz + sqw);
            result.z = MathUtil.asin(2.0f * f / sq);
        }
    }

    public void toEulerAngles(@Nonnull float[] angles) {
        if (angles.length < 3) {
            throw new IllegalArgumentException("The array length must be at least 3");
        }
        float f = this.x * this.y + this.z * this.w;
        float sqx = this.x * this.x;
        float sqy = this.y * this.y;
        float sqz = this.z * this.z;
        float sqw = this.w * this.w;
        float sq = sqx + sqy + sqz + sqw;
        if (f > 0.499f * sq) {
            angles[0] = 0.0f;
            angles[1] = 2.0f * MathUtil.atan2(this.x, this.w);
            angles[2] = 1.5707964f;
        } else if (f < -0.499f * sq) {
            angles[0] = 0.0f;
            angles[1] = -2.0f * MathUtil.atan2(this.x, this.w);
            angles[2] = -1.5707964f;
        } else {
            angles[0] = MathUtil.atan2(2.0f * (this.x * this.w - this.y * this.z), -sqx + sqy - sqz + sqw);
            angles[1] = MathUtil.atan2(2.0f * (this.y * this.w - this.x * this.z), sqx - sqy - sqz + sqw);
            angles[2] = MathUtil.asin(2.0f * f / sq);
        }
    }

    @Nonnull
    public Matrix3 toMatrix3() {
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            return Matrix3.identity();
        }
        float is = MathUtil.approxEqual(sq, 1.0f) ? 2.0f : 2.0f / sq;
        Matrix3 mat = new Matrix3();
        float xs = is * this.x;
        float ys = is * this.y;
        float zs = is * this.z;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = xs * this.w;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = ys * this.w;
        float zz = this.z * zs;
        float zw = zs * this.w;
        mat.m11 = 1.0f - (yy + zz);
        mat.m22 = 1.0f - (xx + zz);
        mat.m33 = 1.0f - (xx + yy);
        mat.m21 = xy - zw;
        mat.m31 = xz + yw;
        mat.m12 = xy + zw;
        mat.m32 = yz - xw;
        mat.m13 = xz - yw;
        mat.m23 = yz + xw;
        return mat;
    }

    @Nonnull
    public Matrix4 toMatrix4() {
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            return Matrix4.identity();
        }
        float is = MathUtil.approxEqual(sq, 1.0f) ? 2.0f : 2.0f / sq;
        Matrix4 mat = new Matrix4();
        float xs = is * this.x;
        float ys = is * this.y;
        float zs = is * this.z;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = xs * this.w;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = ys * this.w;
        float zz = this.z * zs;
        float zw = zs * this.w;
        mat.m11 = 1.0f - (yy + zz);
        mat.m22 = 1.0f - (xx + zz);
        mat.m33 = 1.0f - (xx + yy);
        mat.m21 = xy - zw;
        mat.m31 = xz + yw;
        mat.m12 = xy + zw;
        mat.m32 = yz - xw;
        mat.m13 = xz - yw;
        mat.m23 = yz + xw;
        mat.m44 = 1.0f;
        return mat;
    }

    @Nonnull
    public Matrix3 toMatrix3(@Nullable Matrix3 recycle) {
        if (recycle == null) {
            return this.toMatrix3();
        }
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            recycle.setIdentity();
            return recycle;
        }
        float inv = MathUtil.approxEqual(sq, 1.0f) ? 2.0f : 2.0f / sq;
        float xs = inv * this.x;
        float ys = inv * this.y;
        float zs = inv * this.z;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = xs * this.w;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = ys * this.w;
        float zz = this.z * zs;
        float zw = zs * this.w;
        recycle.m11 = 1.0f - (yy + zz);
        recycle.m21 = xy - zw;
        recycle.m31 = xz + yw;
        recycle.m12 = xy + zw;
        recycle.m22 = 1.0f - (xx + zz);
        recycle.m32 = yz - xw;
        recycle.m13 = xz - yw;
        recycle.m23 = yz + xw;
        recycle.m33 = 1.0f - (xx + yy);
        return recycle;
    }

    @Nonnull
    public Matrix4 toMatrix4(@Nullable Matrix4 recycle) {
        if (recycle == null) {
            return this.toMatrix4();
        }
        float sq = this.lengthSquared();
        if (sq < 1.0E-6f) {
            recycle.setIdentity();
            return recycle;
        }
        float inv = MathUtil.approxEqual(sq, 1.0f) ? 2.0f : 2.0f / sq;
        float xs = inv * this.x;
        float ys = inv * this.y;
        float zs = inv * this.z;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float xw = xs * this.w;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float yw = ys * this.w;
        float zz = this.z * zs;
        float zw = zs * this.w;
        recycle.m11 = 1.0f - (yy + zz);
        recycle.m21 = xy - zw;
        recycle.m31 = xz + yw;
        recycle.m41 = 0.0f;
        recycle.m12 = xy + zw;
        recycle.m22 = 1.0f - (xx + zz);
        recycle.m32 = yz - xw;
        recycle.m42 = 0.0f;
        recycle.m13 = xz - yw;
        recycle.m23 = yz + xw;
        recycle.m33 = 1.0f - (xx + yy);
        recycle.m43 = 0.0f;
        recycle.m14 = 0.0f;
        recycle.m24 = 0.0f;
        recycle.m34 = 0.0f;
        recycle.m44 = 1.0f;
        return recycle;
    }

    public boolean equivalent(@Nonnull Quaternion q) {
        if (this == q) {
            return true;
        }
        return MathUtil.approxEqual(this.x, q.x) && MathUtil.approxEqual(this.y, q.y) && MathUtil.approxEqual(this.z, q.z) && MathUtil.approxEqual(this.w, q.w);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quaternion that = (Quaternion)o;
        if (!MathUtil.exactlyEqual(that.x, this.x)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(that.y, this.y)) {
            return false;
        }
        if (!MathUtil.exactlyEqual(that.z, this.z)) {
            return false;
        }
        return MathUtil.exactlyEqual(that.w, this.w);
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
        result = 31 * result + (this.w != 0.0f ? Float.floatToIntBits(this.w) : 0);
        return result;
    }

    public String toString() {
        return "Quaternion[w: " + this.w + ", x: " + this.x + ", y: " + this.y + ", z: " + this.z + ']';
    }

    @Nonnull
    public Quaternion copy() {
        return new Quaternion(this.x, this.y, this.z, this.w);
    }
}

